<?php
// 이 파일은 새로운 파일 생성시 반드시 포함되어야 함
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

$begin_time = get_microtime();

if (!isset($g5['title'])) {
    $g5['title'] = $config['cf_title'];
    $g5_head_title = $g5['title'];
}
else {
    $g5_head_title = $g5['title']; // 상태바에 표시될 제목
    $g5_head_title .= " | ".$config['cf_title'];
}

// 현재 접속자
// 게시판 제목에 ' 포함되면 오류 발생
$g5['lo_location'] = addslashes($g5['title']);
if (!$g5['lo_location'])
    $g5['lo_location'] = addslashes($_SERVER['REQUEST_URI']);
$g5['lo_url'] = addslashes($_SERVER['REQUEST_URI']);
if (strstr($g5['lo_url'], '/'.G5_ADMIN_DIR.'/') || $is_admin == 'super') $g5['lo_url'] = '';

/*
// 만료된 페이지로 사용하시는 경우
header("Cache-Control: no-cache"); // HTTP/1.1
header("Expires: 0"); // rfc2616 - Section 14.21
header("Pragma: no-cache"); // HTTP/1.0
*/
?>
<!doctype html>
<html lang="ko">
<head>
<meta charset="utf-8">
<?php
if (G5_IS_MOBILE) {
    echo '<meta name="viewport" content="width=device-width,initial-scale=1.0,minimum-scale=0,maximum-scale=10">'.PHP_EOL;
    echo '<meta name="HandheldFriendly" content="true">'.PHP_EOL;
    echo '<meta name="format-detection" content="telephone=no">'.PHP_EOL;
} else {
    echo '<meta http-equiv="imagetoolbar" content="no">'.PHP_EOL;
    echo '<meta http-equiv="X-UA-Compatible" content="IE=10,chrome=1">'.PHP_EOL;
}

//관리자화면이 아닌 상품일 때
$seo_url = $seo_image = '';
$is_seo = false;
if(!defined('G5_IS_ADMIN')) {
	if($it['it_id']) {
		$seo_title = htmlspecialchars(apms_get_text($it['it_name']) . ' < '. $config['cf_title']);
		$seo_subject = htmlspecialchars(apms_get_text($it['it_name']));
		$seo_desc = htmlspecialchars(apms_get_text($it['it_basic']));
		$seo_publisher = htmlspecialchars(apms_get_text($config['cf_title']));
		$seo_creator = htmlspecialchars($author['mb_nick']);
		$seo_keyword = htmlspecialchars($it['pt_tag']);
		$seo_url = G5_SHOP_URL.'/item.php?it_id='.$it['it_id'];
		$seo_img = apms_it_thumbnail($it, 0, 0, false, true);
		$seo_image = $seo_img['src'];
		$is_seo = true;
	} else if($bo_table && $wr_id) { // 게시물
		$seo_title = htmlspecialchars(apms_get_text($write['wr_subject']) . ' < '. $config['cf_title']);
		$seo_subject = htmlspecialchars(apms_get_text($write['wr_subject']));
		$seo_desc = htmlspecialchars(apms_cut_text($write['wr_content'], 200));
		$seo_publisher = htmlspecialchars(apms_get_text($config['cf_title']));
		$seo_creator = htmlspecialchars(apms_get_text($write['wr_name']));
		$seo_keyword = ($write['as_tag']) ? $write['as_tag'] : $write['ca_name'];
		$seo_keyword = htmlspecialchars(apms_get_text($seo_keyword));
		$seo_url = G5_BBS_URL.'/board.php?bo_table='.$bo_table.'&amp;wr_id='.$wr_id;
		$seo_img = apms_wr_thumbnail($bo_table, $write, 0, 0, false, true); // 썸네일
		$seo_image = $seo_img['src'];
		$is_seo = true;
	}

	if($is_seo) {
?>
<meta name="title" content="<?php echo $seo_title;?>" />
<meta name="subject" content="<?php echo $seo_subject;?>" />
<meta name="publisher" content="<?php echo $seo_publisher;?>" />
<meta name="author" content="<?php echo $seo_creator;?>" />
<meta name="keywords" content="<?php echo $seo_keyword;?>" />
<meta name="description" content="<?php echo $seo_desc;?>" />
<meta name="robots" content="index,follow" />
<!-- Facebook -->
<meta property="og:title" content="<?php echo $seo_title; ?>"/>
<meta property="og:site_name" content="<?php echo $seo_publisher;?>"/>
<meta property="og:author" content="<?php echo $seo_creator;?>" />
<meta property="og:url" content="<?php echo $seo_url; ?>"/>
<meta property="og:description"	content="<?php echo $seo_desc;?>"/>
<meta property="og:image" content="<?php echo $seo_image;?>"/>
<?php
	}
}

if($config['cf_add_meta'])
    echo $config['cf_add_meta'].PHP_EOL;
?>
<title><?php echo apms_get_text($g5_head_title); ?></title>
<?php
if (defined('G5_IS_ADMIN')) {
    echo '<link rel="stylesheet" href="'.G5_ADMIN_URL.'/css/admin.css">'.PHP_EOL;
} else {
    $shop_css = '';
    if (defined('_SHOP_')) $shop_css = '_shop';
    echo '<link rel="stylesheet" href="'.G5_CSS_URL.'/'.(G5_IS_MOBILE?'mobile':'default').$shop_css.'.css">'.PHP_EOL;
}
?>
<link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css">
<?php if($seo_url) { ?>
<link rel="canonical" href="<?php echo $seo_url; ?>" />
<?php } ?>
<!--[if lte IE 8]>
<script src="<?php echo G5_JS_URL ?>/html5.js"></script>
<![endif]-->
<script>
// 자바스크립트에서 사용하는 전역변수 선언
var g5_url       = "<?php echo G5_URL ?>";
var g5_bbs_url   = "<?php echo G5_BBS_URL ?>";
var g5_is_member = "<?php echo isset($is_member)?$is_member:''; ?>";
var g5_is_admin  = "<?php echo isset($is_admin)?$is_admin:''; ?>";
var g5_is_mobile = "<?php echo G5_IS_MOBILE ?>";
var g5_bo_table  = "<?php echo isset($bo_table)?$bo_table:''; ?>";
var g5_sca       = "<?php echo isset($sca)?$sca:''; ?>";
var g5_pim       = "<?php echo APMS_PIM ?>";
var g5_editor    = "<?php echo ($config['cf_editor'] && $board['bo_use_dhtml_editor'])?$config['cf_editor']:''; ?>";
var g5_cookie_domain = "<?php echo G5_COOKIE_DOMAIN ?>";
<?php
if ($is_admin) {
    echo 'var g5_admin_url = "'.G5_ADMIN_URL.'";'.PHP_EOL;
}
?>
</script>
<script src="<?php echo G5_JS_URL ?>/jquery-1.8.3.min.js"></script>
<?php
if (defined('_SHOP_')) {
    if(!G5_IS_MOBILE) {
?>
<script src="<?php echo G5_JS_URL ?>/jquery.shop.menu.js"></script>
<?php
    }
} else {
?>
<script src="<?php echo G5_JS_URL ?>/jquery.menu.js"></script>
<?php } ?>
<script src="<?php echo G5_JS_URL ?>/common.js"></script>
<script src="<?php echo G5_JS_URL ?>/wrest.js"></script>
<script src="<?php echo G5_JS_URL ?>/apms.js"></script>
<?php
if(G5_IS_MOBILE) {
    echo '<script src="'.G5_JS_URL.'/modernizr.custom.70111.js"></script>'.PHP_EOL; // overflow scroll 감지
}
if(!defined('G5_IS_ADMIN'))
    echo $config['cf_add_script'];
?>
</head>
<body <?php echo isset($g5['body_script']) ? $g5['body_script'] : ''; ?>>
<?php
if ($is_member) { // 회원이라면 로그인 중이라는 메세지를 출력해준다.
    $sr_admin_msg = '';
    if ($is_admin == 'super') $sr_admin_msg = "최고관리자 ";
    else if ($is_admin == 'group') $sr_admin_msg = "그룹관리자 ";
    else if ($is_admin == 'board') $sr_admin_msg = "게시판관리자 ";

    echo '<div id="hd_login_msg">'.$sr_admin_msg.$member['mb_nick'].'님 로그인 중 ';
    echo '<a href="'.G5_BBS_URL.'/logout.php">로그아웃</a></div>';
}
include_once(G5_LIB_PATH.'/thumbnail.lib.php');
?>